/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;

public final class GeneralizedLinearRegressionExample$ {
    public static final GeneralizedLinearRegressionExample$ MODULE$ = new GeneralizedLinearRegressionExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("GeneralizedLinearRegressionExample").getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_linear_regression_data.txt");
        GeneralizedLinearRegression glr = new GeneralizedLinearRegression().setFamily("gaussian").setLink("identity").setMaxIter(10).setRegParam(0.3);
        GeneralizedLinearRegressionModel model = (GeneralizedLinearRegressionModel)glr.fit(dataset);
        Predef$.MODULE$.println((Object)("Coefficients: " + model.coefficients()));
        Predef$.MODULE$.println((Object)("Intercept: " + model.intercept()));
        GeneralizedLinearRegressionTrainingSummary summary = model.summary();
        Predef$.MODULE$.println((Object)("Coefficient Standard Errors: " + Predef$.MODULE$.wrapDoubleArray(summary.coefficientStandardErrors()).mkString(",")));
        Predef$.MODULE$.println((Object)("T Values: " + Predef$.MODULE$.wrapDoubleArray(summary.tValues()).mkString(",")));
        Predef$.MODULE$.println((Object)("P Values: " + Predef$.MODULE$.wrapDoubleArray(summary.pValues()).mkString(",")));
        Predef$.MODULE$.println((Object)("Dispersion: " + summary.dispersion()));
        Predef$.MODULE$.println((Object)("Null Deviance: " + summary.nullDeviance()));
        Predef$.MODULE$.println((Object)("Residual Degree Of Freedom Null: " + summary.residualDegreeOfFreedomNull()));
        Predef$.MODULE$.println((Object)("Deviance: " + summary.deviance()));
        Predef$.MODULE$.println((Object)("Residual Degree Of Freedom: " + summary.residualDegreeOfFreedom()));
        Predef$.MODULE$.println((Object)("AIC: " + summary.aic()));
        Predef$.MODULE$.println((Object)"Deviance Residuals: ");
        summary.residuals().show();
        spark.stop();
    }

    private GeneralizedLinearRegressionExample$() {
    }
}

