/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.package$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder$;
import org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u0013&\u0001IB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!)\u0007A!A!\u0002\u00131\u0007\"B5\u0001\t\u0003Q\u0007bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007i\u0002\u0001\u000b\u0011B:\t\u000fU\u0004!\u0019!C\u0005m\"1Q\u0010\u0001Q\u0001\n]DqA \u0001C\u0002\u0013%a\u000f\u0003\u0004\u0000\u0001\u0001\u0006Ia\u001e\u0005\t\u0003\u0003\u0001!\u0019!C\u0005m\"9\u00111\u0001\u0001!\u0002\u00139\b\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0011!\t)\u0002\u0001Q\u0001\n\u0005%\u0001\"CA\f\u0001\t\u0007I\u0011BA\u0004\u0011!\tI\u0002\u0001Q\u0001\n\u0005%\u0001\"CA\u000e\u0001\t\u0007I\u0011BA\u0004\u0011!\ti\u0002\u0001Q\u0001\n\u0005%\u0001\"CA\u0010\u0001\t\u0007I\u0011BA\u0011\u0011!\tI\u0005\u0001Q\u0001\n\u0005\r\u0002\"CA&\u0001\t\u0007I\u0011BA'\u0011!\t\t\u0006\u0001Q\u0001\n\u0005=\u0003\"CA*\u0001\t\u0007I\u0011BA+\u0011!\ti\u0006\u0001Q\u0001\n\u0005]\u0003bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!!\u001d\u0001\t\u0003\t9\bC\u0004\u0002\u0000\u0001!\t!!!\b\u0013\u0005\u001dU%!A\t\u0002\u0005%e\u0001\u0003\u0013&\u0003\u0003E\t!a#\t\r%\fC\u0011AAJ\u0011%\t)*II\u0001\n\u0003\t9J\u0001\rD_6\u0004xn]5uK.+\u0017p\u0015;bi\u0016,enY8eKJT!AJ\u0014\u0002\u0013M$(/Z1nS:<'B\u0001\u0015*\u0003%)\u00070Z2vi&|gN\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001!F\u00024+j\u001a\"\u0001\u0001\u001b\u0011\u0007U2\u0004(D\u0001&\u0013\t9TEA\tTi\u0006$X\rV=qKN,enY8eKJ\u0004\"!\u000f\u001e\r\u0001\u0011)1\b\u0001b\u0001y\t\ta+\u0005\u0002>\u0007B\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t9aj\u001c;iS:<\u0007C\u0001 E\u0013\t)uHA\u0002B]f\f!b[3z\u000b:\u001cw\u000eZ3s!\rAUjQ\u0007\u0002\u0013*\u0011!jS\u0001\tK:\u001cw\u000eZ3sg*\u0011A*K\u0001\tG\u0006$\u0018\r\\=ti&\u0011a*\u0013\u0002\u0012\u000bb\u0004(/Z:tS>tWI\\2pI\u0016\u0014\u0018AC;tKJ\\U-_#oGB\u0019\u0011K\u0015+\u000e\u0003%J!aU\u0015\u0003\u000f\u0015s7m\u001c3feB\u0011\u0011(\u0016\u0003\u0006-\u0002\u0011\r\u0001\u0010\u0002\u0002\u0017\u0006Qa/\u00197F]\u000e|G-\u001a:\u0011\u0007E\u0013\u0006(A\u0005ti\u0006$XMT1nKB\u00111L\u0019\b\u00039\u0002\u0004\"!X \u000e\u0003yS!aX\u0019\u0002\rq\u0012xn\u001c;?\u0013\t\tw(\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1@\u0003\u0019A\u0017m\u001d+uYB\u0011ahZ\u0005\u0003Q~\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0007W2lgn\u001c9\u0011\tU\u0002A\u000b\u000f\u0005\u0006\r\u001a\u0001\ra\u0012\u0005\u0006\u001f\u001a\u0001\r\u0001\u0015\u0005\u0006/\u001a\u0001\r\u0001\u0017\u0005\u00063\u001a\u0001\rA\u0017\u0005\bK\u001a\u0001\n\u00111\u0001g\u0003Q)8/\u001a:LKf,\u0005\u0010\u001d:fgNLwN\\#oGV\t1\u000fE\u0002I\u001bR\u000bQ#^:fe.+\u00170\u0012=qe\u0016\u001c8/[8o\u000b:\u001c\u0007%A\ftG\",W.\u0019$pe\u001e\u0013x.\u001e9j]\u001e\\U-\u001f*poV\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{S\u0005)A/\u001f9fg&\u0011A0\u001f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001G:dQ\u0016l\u0017MR8s\u000fJ|W\u000f]5oO.+\u0017PU8xA\u0005\u00192o\u00195f[\u00064uN]+tKJ\\U-\u001f*po\u0006!2o\u00195f[\u00064uN]+tKJ\\U-\u001f*po\u0002\n\u0001d]2iK6\fgi\u001c:D_6\u0004xn]5uK.+\u0017PU8x\u0003e\u00198\r[3nC\u001a{'oQ8na>\u001c\u0018\u000e^3LKf\u0014vn\u001e\u0011\u0002#U\u001cXM]&fsB\u0013xN[3di&|g.\u0006\u0002\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010-\u000b1\"\u001a=qe\u0016\u001c8/[8og&!\u00111CA\u0007\u0005A)fn]1gKB\u0013xN[3di&|g.\u0001\nvg\u0016\u00148*Z=Qe>TWm\u0019;j_:\u0004\u0013!F4s_V\u0004\u0018N\\4LKf\u0004&o\u001c6fGRLwN\\\u0001\u0017OJ|W\u000f]5oO.+\u0017\u0010\u0015:pU\u0016\u001cG/[8oA\u000512m\\7q_NLG/Z&fsB\u0013xN[3di&|g.A\fd_6\u0004xn]5uK.+\u0017\u0010\u0015:pU\u0016\u001cG/[8oA\u0005)rM]8va&twmS3z'\u0016\u0014\u0018.\u00197ju\u0016\u0014XCAA\u0012!\u0015\t)#a\u0011D\u001d\u0011\t9#a\u0010\u000f\t\u0005%\u0012Q\b\b\u0005\u0003W\tYD\u0004\u0003\u0002.\u0005eb\u0002BA\u0018\u0003oqA!!\r\u000269\u0019Q,a\r\n\u0003AJ!AL\u0018\n\u00051j\u0013B\u0001\u0016,\u0013\ta\u0015&\u0003\u0002K\u0017&\u0019\u0011\u0011I%\u0002#\u0015C\bO]3tg&|g.\u00128d_\u0012,'/\u0003\u0003\u0002F\u0005\u001d#AC*fe&\fG.\u001b>fe*\u0019\u0011\u0011I%\u0002-\u001d\u0014x.\u001e9j]\u001e\\U-_*fe&\fG.\u001b>fe\u0002\n\u0011#^:fe.+\u0017pU3sS\u0006d\u0017N_3s+\t\ty\u0005E\u0003\u0002&\u0005\rC+\u0001\nvg\u0016\u00148*Z=TKJL\u0017\r\\5{KJ\u0004\u0013aG;tKJ\\U-\u001f*poR{wJ\u00196EKN,'/[1mSj,'/\u0006\u0002\u0002XA)\u0011QEA-)&!\u00111LA$\u00051!Um]3sS\u0006d\u0017N_3s\u0003q)8/\u001a:LKf\u0014vn\u001e+p\u001f\nTG)Z:fe&\fG.\u001b>fe\u0002\n\u0011#\u001a8d_\u0012,wI]8va&twmS3z)\t\t\u0019\u0007\u0005\u0003\u0002\f\u0005\u0015\u0014\u0002BA4\u0003\u001b\u0011\u0011\"\u00168tC\u001a,'k\\<\u0002\u001b\u0015t7m\u001c3f+N,'oS3z)\u0011\t\u0019'!\u001c\t\r\u0005=D\u00041\u0001U\u0003\u001d)8/\u001a:LKf\f!#\u001a8d_\u0012,7i\\7q_NLG/Z&fsR!\u00111MA;\u0011\u0019\ty'\ba\u0001)R1\u00111MA=\u0003{Bq!a\u001f\u001f\u0001\u0004\t\u0019'A\u0006he>,\b/\u001b8h\u0017\u0016L\bbBA8=\u0001\u0007\u00111M\u0001\u0013I\u0016\u001cw\u000eZ3D_6\u0004xn]5uK.+\u0017\u0010F\u0002U\u0003\u0007Cq!!\" \u0001\u0004\t\u0019'A\u0002s_^\f\u0001dQ8na>\u001c\u0018\u000e^3LKf\u001cF/\u0019;f\u000b:\u001cw\u000eZ3s!\t)\u0014eE\u0002\"\u0003\u001b\u00032APAH\u0013\r\t\tj\u0010\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005%\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0004\u0002\u001a\u0006=\u0016\u0011W\u000b\u0003\u00037S3AZAOW\t\ty\n\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\u0013Ut7\r[3dW\u0016$'bAAU\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00161\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!\u0002,$\u0005\u0004aD!B\u001e$\u0005\u0004a\u0004")
public class CompositeKeyStateEncoder<K, V>
extends StateTypesEncoder<V> {
    private final Encoder<K> userKeyEnc;
    private final String stateName;
    private final ExpressionEncoder<K> userKeyExpressionEnc;
    private final StructType schemaForGroupingKeyRow;
    private final StructType schemaForUserKeyRow;
    private final StructType schemaForCompositeKeyRow;
    private final UnsafeProjection userKeyProjection;
    private final UnsafeProjection groupingKeyProjection;
    private final UnsafeProjection compositeKeyProjection;
    private final ExpressionEncoder.Serializer<Object> groupingKeySerializer;
    private final ExpressionEncoder.Serializer<K> userKeySerializer;
    private final ExpressionEncoder.Deserializer<K> userKeyRowToObjDeserializer;

    public static <K, V> boolean $lessinit$greater$default$5() {
        return CompositeKeyStateEncoder$.MODULE$.$lessinit$greater$default$5();
    }

    private ExpressionEncoder<K> userKeyExpressionEnc() {
        return this.userKeyExpressionEnc;
    }

    private StructType schemaForGroupingKeyRow() {
        return this.schemaForGroupingKeyRow;
    }

    private StructType schemaForUserKeyRow() {
        return this.schemaForUserKeyRow;
    }

    private StructType schemaForCompositeKeyRow() {
        return this.schemaForCompositeKeyRow;
    }

    private UnsafeProjection userKeyProjection() {
        return this.userKeyProjection;
    }

    private UnsafeProjection groupingKeyProjection() {
        return this.groupingKeyProjection;
    }

    private UnsafeProjection compositeKeyProjection() {
        return this.compositeKeyProjection;
    }

    private ExpressionEncoder.Serializer<Object> groupingKeySerializer() {
        return this.groupingKeySerializer;
    }

    private ExpressionEncoder.Serializer<K> userKeySerializer() {
        return this.userKeySerializer;
    }

    private ExpressionEncoder.Deserializer<K> userKeyRowToObjDeserializer() {
        return this.userKeyRowToObjDeserializer;
    }

    @Override
    public UnsafeRow encodeGroupingKey() {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(this.stateName);
        }
        Object groupingKey = keyOption.get();
        InternalRow groupingKeyRow = this.groupingKeySerializer().apply(groupingKey);
        return this.groupingKeyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{groupingKeyRow})));
    }

    public UnsafeRow encodeUserKey(K userKey) {
        InternalRow userKeyRow = this.userKeySerializer().apply(userKey);
        return this.userKeyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{userKeyRow})));
    }

    public UnsafeRow encodeCompositeKey(K userKey) {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(this.stateName);
        }
        Object groupingKey = keyOption.get();
        InternalRow keyRow = this.groupingKeySerializer().apply(groupingKey);
        InternalRow userKeyRow = this.userKeySerializer().apply(userKey);
        return this.compositeKeyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{keyRow, userKeyRow})));
    }

    public UnsafeRow encodeCompositeKey(UnsafeRow groupingKey, UnsafeRow userKey) {
        return this.compositeKeyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{groupingKey, userKey})));
    }

    public K decodeCompositeKey(UnsafeRow row) {
        return (K)this.userKeyRowToObjDeserializer().apply((InternalRow)row.getStruct(1, this.userKeyEnc.schema().length()));
    }

    public CompositeKeyStateEncoder(ExpressionEncoder<Object> keyEncoder, Encoder<K> userKeyEnc, Encoder<V> valEncoder, String stateName, boolean hasTtl) {
        this.userKeyEnc = userKeyEnc;
        this.stateName = stateName;
        super(keyEncoder, valEncoder, stateName, hasTtl);
        this.userKeyExpressionEnc = package$.MODULE$.encoderFor(userKeyEnc);
        this.schemaForGroupingKeyRow = new StructType().add("key", (DataType)keyEncoder.schema());
        this.schemaForUserKeyRow = new StructType().add("userKey", (DataType)userKeyEnc.schema());
        this.schemaForCompositeKeyRow = TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getCompositeKeySchema(keyEncoder.schema(), userKeyEnc.schema());
        this.userKeyProjection = UnsafeProjection$.MODULE$.create(this.schemaForUserKeyRow());
        this.groupingKeyProjection = UnsafeProjection$.MODULE$.create(this.schemaForGroupingKeyRow());
        this.compositeKeyProjection = UnsafeProjection$.MODULE$.create(this.schemaForCompositeKeyRow());
        this.groupingKeySerializer = keyEncoder.createSerializer();
        this.userKeySerializer = this.userKeyExpressionEnc().createSerializer();
        this.userKeyRowToObjDeserializer = this.userKeyExpressionEnc().resolveAndBind(this.userKeyExpressionEnc().resolveAndBind$default$1(), this.userKeyExpressionEnc().resolveAndBind$default$2()).createDeserializer();
    }
}

