/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.attribute;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeKeys$;
import org.apache.spark.ml.attribute.AttributeType$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class AttributeGroup$
implements Serializable {
    public static final AttributeGroup$ MODULE$ = new AttributeGroup$();

    public AttributeGroup fromMetadata(Metadata metadata2, String name) {
        if (metadata2.contains(AttributeKeys$.MODULE$.ATTRIBUTES())) {
            int numAttrs = (int)metadata2.getLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES());
            Attribute[] attributes = new Attribute[numAttrs];
            Metadata attrMetadata = metadata2.getMetadata(AttributeKeys$.MODULE$.ATTRIBUTES());
            if (attrMetadata.contains(AttributeType$.MODULE$.Numeric().name())) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])attrMetadata.getMetadataArray(AttributeType$.MODULE$.Numeric().name())), (Function1 & Serializable)metadata -> NumericAttribute$.MODULE$.fromMetadata((Metadata)metadata), ClassTag$.MODULE$.apply(NumericAttribute.class))), (Function1 & Serializable)attr -> {
                    attributes[BoxesRunTime.unboxToInt((Object)attr.index().get())] = attr;
                    return BoxedUnit.UNIT;
                });
            }
            if (attrMetadata.contains(AttributeType$.MODULE$.Nominal().name())) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])attrMetadata.getMetadataArray(AttributeType$.MODULE$.Nominal().name())), (Function1 & Serializable)metadata -> NominalAttribute$.MODULE$.fromMetadata((Metadata)metadata), ClassTag$.MODULE$.apply(NominalAttribute.class))), (Function1 & Serializable)attr -> {
                    attributes[BoxesRunTime.unboxToInt((Object)attr.index().get())] = attr;
                    return BoxedUnit.UNIT;
                });
            }
            if (attrMetadata.contains(AttributeType$.MODULE$.Binary().name())) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])attrMetadata.getMetadataArray(AttributeType$.MODULE$.Binary().name())), (Function1 & Serializable)metadata -> BinaryAttribute$.MODULE$.fromMetadata((Metadata)metadata), ClassTag$.MODULE$.apply(BinaryAttribute.class))), (Function1 & Serializable)attr -> {
                    attributes[BoxesRunTime.unboxToInt((Object)attr.index().get())] = attr;
                    return BoxedUnit.UNIT;
                });
            }
            for (int i = 0; i < numAttrs; ++i) {
                if (attributes[i] != null) continue;
                attributes[i] = NumericAttribute$.MODULE$.defaultAttr();
            }
            return new AttributeGroup(name, attributes);
        }
        if (metadata2.contains(AttributeKeys$.MODULE$.NUM_ATTRIBUTES())) {
            return new AttributeGroup(name, (int)metadata2.getLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES()));
        }
        return new AttributeGroup(name);
    }

    public AttributeGroup fromStructField(StructField field) {
        DataType dataType = field.dataType();
        VectorUDT vectorUDT = new VectorUDT();
        Predef$.MODULE$.require(!(dataType != null ? !dataType.equals((Object)vectorUDT) : vectorUDT != null));
        if (field.metadata().contains(AttributeKeys$.MODULE$.ML_ATTR())) {
            return this.fromMetadata(field.metadata().getMetadata(AttributeKeys$.MODULE$.ML_ATTR()), field.name());
        }
        return new AttributeGroup(field.name());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AttributeGroup$.class);
    }

    private AttributeGroup$() {
    }
}

