import types, { ASTNode } from "./lib/types";
import { parse } from "./lib/parser";
import { Options } from "./lib/options";
export interface Parser {
    parse(source: string, options?: any): ASTNode;
}
declare function print(node: ASTNode, options?: Options): import("./lib/printer").PrintResultType;
declare function prettyPrint(node: ASTNode, options?: Options): import("./lib/printer").PrintResultType;
interface Transformer {
    (ast: ASTNode, callback: (ast: ASTNode) => void): void;
}
interface RunOptions extends Options {
    writeback?(code: string): void;
}
declare function run(transformer: Transformer, options?: RunOptions): void;
interface Main {
    parse: typeof parse;
    visit: typeof types.visit;
    print: typeof print;
    prettyPrint: typeof prettyPrint;
    types: typeof types;
    run: typeof run;
}
declare const main: Main;
export default main;
export { ASTNode, NamedTypes, Builders, NodePath, Type, } from "./lib/types";
export { Options } from "./lib/options";
