/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedArgumentExpression;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.connector.catalog.DefaultValue;
import org.apache.spark.sql.connector.catalog.procedures.BoundProcedure;
import org.apache.spark.sql.connector.catalog.procedures.ProcedureParameter;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.util.ArrayImplicits$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NamedParametersSupport$ {
    public static final NamedParametersSupport$ MODULE$ = new NamedParametersSupport$();

    public Tuple2<Seq<Expression>, Seq<NamedArgumentExpression>> splitAndCheckNamedArguments(Seq<Expression> args, String functionName) {
        Tuple2 tuple2 = args.span((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NamedParametersSupport$.$anonfun$splitAndCheckNamedArguments$1(x$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq positionalArgs = (Seq)tuple2._1();
        Seq namedArgs = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)positionalArgs, (Object)namedArgs);
        Seq positionalArgs2 = (Seq)tuple22._1();
        Seq namedArgs2 = (Seq)tuple22._2();
        Set namedParametersSet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        return new Tuple2((Object)positionalArgs2, ((IterableOps)namedArgs2.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Expression namedArg;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (namedArg = (Expression)tuple2._1()) instanceof NamedArgumentExpression) {
                NamedArgumentExpression namedArgumentExpression = (NamedArgumentExpression)namedArg;
                String parameterName = namedArgumentExpression.key();
                if (namedParametersSet.contains((Object)parameterName)) {
                    throw QueryCompilationErrors$.MODULE$.doubleNamedArgumentReference(functionName, parameterName);
                }
                namedParametersSet.add((Object)parameterName);
                return namedArgumentExpression;
            }
            if (tuple2 != null) {
                int index = tuple2._2$mcI$sp();
                throw QueryCompilationErrors$.MODULE$.unexpectedPositionalArgument(functionName, ((NamedArgumentExpression)namedArgs2.apply(index - 1)).key());
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public final Seq<Expression> defaultRearrange(FunctionSignature functionSignature, Seq<Expression> args, String functionName) {
        return this.defaultRearrange(functionName, functionSignature.parameters(), args);
    }

    public final Seq<Expression> defaultRearrange(BoundProcedure procedure, Seq<Expression> args) {
        return this.defaultRearrange(procedure.name(), (Seq<InputParameter>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])procedure.parameters()), (Function1 & Serializable)param -> MODULE$.toInputParameter((ProcedureParameter)param), ClassTag$.MODULE$.apply(InputParameter.class)))), args);
    }

    private InputParameter toInputParameter(ProcedureParameter param) {
        Option defaultValueExpr = Option$.MODULE$.apply((Object)param.defaultValue()).map((Function1 & Serializable)defaultValue -> ResolveDefaultColumns$.MODULE$.analyze(param.name(), param.dataType(), (DefaultValue)defaultValue, "CALL"));
        return new InputParameter(param.name(), (Option<Expression>)defaultValueExpr);
    }

    private Seq<Expression> defaultRearrange(String routineName, Seq<InputParameter> parameters, Seq<Expression> args) {
        if (((IterableOnceOps)parameters.dropWhile((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)NamedParametersSupport$.$anonfun$defaultRearrange$2(x$3)))).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)NamedParametersSupport$.$anonfun$defaultRearrange$3(x$4)))) {
            throw QueryCompilationErrors$.MODULE$.unexpectedRequiredParameter(routineName, parameters);
        }
        Tuple2<Seq<Expression>, Seq<NamedArgumentExpression>> tuple2 = this.splitAndCheckNamedArguments(args, routineName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq positionalArgs = (Seq)tuple2._1();
        Seq namedArgs = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)positionalArgs, (Object)namedArgs);
        Seq positionalArgs2 = (Seq)tuple22._1();
        Seq namedArgs2 = (Seq)tuple22._2();
        Seq namedParameters = (Seq)parameters.drop(positionalArgs2.size());
        Seq allParameterNames = (Seq)parameters.map((Function1 & Serializable)x$6 -> x$6.name());
        scala.collection.immutable.Set parameterNamesSet = allParameterNames.toSet();
        scala.collection.immutable.Set positionalParametersSet = ((IterableOnceOps)allParameterNames.take(positionalArgs2.size())).toSet();
        namedArgs2.foreach((Function1 & Serializable)namedArg -> {
            NamedParametersSupport$.$anonfun$defaultRearrange$5(parameterNamesSet, routineName, positionalParametersSet, namedArg);
            return BoxedUnit.UNIT;
        });
        if (parameters.size() < args.length()) {
            ArraySeq validParameterSizes = ArrayImplicits$.MODULE$.SparkArrayOps((Object)Array$.MODULE$.range(parameters.count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)NamedParametersSupport$.$anonfun$defaultRearrange$6(x$7))), parameters.size() + 1)).toImmutableArraySeq();
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(routineName, (Seq<Object>)validParameterSizes, args.length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Map namedArgMap = ((IterableOnceOps)namedArgs2.map((Function1 & Serializable)namedArg -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)namedArg.key()), (Object)namedArg.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Seq rearrangedNamedArgs = (Seq)((IterableOps)namedParameters.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                InputParameter param = (InputParameter)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return (Expression)namedArgMap.getOrElse((Object)param.name(), (Function0 & Serializable)() -> {
                    if (param.default().isEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.requiredParameterNotFound(routineName, param.name(), index);
                    }
                    return (Expression)param.default().get();
                });
            }
            throw new MatchError((Object)tuple2);
        });
        Seq rearrangedArgs = (Seq)positionalArgs2.$plus$plus((IterableOnce)rearrangedNamedArgs);
        Predef$.MODULE$.assert(rearrangedArgs.size() == parameters.size());
        return rearrangedArgs;
    }

    public static final /* synthetic */ boolean $anonfun$splitAndCheckNamedArguments$1(Expression x$1) {
        return !(x$1 instanceof NamedArgumentExpression);
    }

    public static final /* synthetic */ boolean $anonfun$defaultRearrange$2(InputParameter x$3) {
        return x$3.default().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$defaultRearrange$3(InputParameter x$4) {
        return x$4.default().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$defaultRearrange$5(scala.collection.immutable.Set parameterNamesSet$1, String routineName$1, scala.collection.immutable.Set positionalParametersSet$1, NamedArgumentExpression namedArg) {
        String parameterName = namedArg.key();
        if (!parameterNamesSet$1.contains((Object)parameterName)) {
            throw QueryCompilationErrors$.MODULE$.unrecognizedParameterName(routineName$1, namedArg.key(), (Seq<String>)parameterNamesSet$1.toSeq());
        }
        if (positionalParametersSet$1.contains((Object)parameterName)) {
            throw QueryCompilationErrors$.MODULE$.positionalAndNamedArgumentDoubleReference(routineName$1, namedArg.key());
        }
    }

    public static final /* synthetic */ boolean $anonfun$defaultRearrange$6(InputParameter x$7) {
        return x$7.default().isEmpty();
    }

    private NamedParametersSupport$() {
    }
}

