/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.ChiSqSelector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaChiSqSelectorExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaChiSqSelectorExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{7, Vectors.dense((double)0.0, (double[])new double[]{0.0, 18.0, 1.0}), 1.0}), RowFactory.create((Object[])new Object[]{8, Vectors.dense((double)0.0, (double[])new double[]{1.0, 12.0, 0.0}), 0.0}), RowFactory.create((Object[])new Object[]{9, Vectors.dense((double)1.0, (double[])new double[]{0.0, 15.0, 0.1}), 0.0}));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty()), new StructField("clicked", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        ChiSqSelector selector = new ChiSqSelector().setNumTopFeatures(1).setFeaturesCol("features").setLabelCol("clicked").setOutputCol("selectedFeatures");
        Dataset result = selector.fit(df).transform(df);
        System.out.println("ChiSqSelector output with top " + selector.getNumTopFeatures() + " features selected");
        result.show();
        spark.stop();
    }
}

