/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$NodeData$;
import org.apache.spark.ml.tree.EnsembleModelReadWrite;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$EnsembleNodeData$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.VersionUtils$;
import org.json4s.DefaultFormats$;
import org.json4s.JObject;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class EnsembleModelReadWrite$ {
    public static final EnsembleModelReadWrite$ MODULE$ = new EnsembleModelReadWrite$();

    public <M extends Params & TreeEnsembleModel<? extends DecisionTreeModel>> void saveImpl(M instance, String path, SparkSession sparkSession, JObject extraMetadata) {
        DefaultParamsWriter$.MODULE$.saveMetadata(instance, path, sparkSession, (Option<JObject>)new Some((Object)extraMetadata));
        Tuple3[] treesMetadataWeights = (Tuple3[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])((TreeEnsembleModel<? extends DecisionTreeModel>)instance).trees()))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
                int treeID = tuple2._2$mcI$sp();
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)treeID), (Object)DefaultParamsWriter$.MODULE$.getMetadataToSave((Params)((Object)tree), sparkSession), (Object)BoxesRunTime.boxToDouble((double)((TreeEnsembleModel)((Object)instance)).treeWeights()[treeID]));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        String treesMetadataPath = new Path(path, "treesMetadata").toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator1$1() {
            }
        }
        sparkSession.createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)treesMetadataWeights).toImmutableArraySeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator1$1())).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"treeID", "metadata", "weights"})).repartition(1).write().parquet(treesMetadataPath);
        String dataPath = new Path(path, "data").toString();
        int numDataParts = DecisionTreeModelReadWrite$NodeData$.MODULE$.inferNumPartitions(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((TreeEnsembleModel<? extends DecisionTreeModel>)instance).trees()), (Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.numNodes()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        SparkContext qual$1 = sparkSession.sparkContext();
        ArraySeq x$1 = ArrayImplicits$.MODULE$.SparkArrayOps((Object)ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])((TreeEnsembleModel<? extends DecisionTreeModel>)instance).trees()))).toImmutableArraySeq();
        int x$2 = qual$1.parallelize$default$2();
        RDD nodeDataRDD = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)).flatMap((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
                int treeID = tuple2._2$mcI$sp();
                return EnsembleModelReadWrite$EnsembleNodeData$.MODULE$.build(tree, treeID);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(EnsembleModelReadWrite.EnsembleNodeData.class));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.tree.EnsembleModelReadWrite.EnsembleNodeData").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator2$1() {
            }
        }
        sparkSession.createDataFrame(nodeDataRDD, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator2$1())).repartition(numDataParts).write().parquet(dataPath);
    }

    public Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> loadImpl(String path, SparkSession sparkSession, String className, String treeClassName) {
        DefaultFormats$ format = DefaultFormats$.MODULE$;
        DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, sparkSession, className);
        JValue impurityJson = metadata.getParamValue("impurity");
        String impurityType = (String)Param$.MODULE$.jsonDecode(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(impurityJson, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())));
        String treesMetadataPath = new Path(path, "treesMetadata").toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator5$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator5$2() {
            }
        }
        RDD treesMetadataRDD = sparkSession.read().parquet(treesMetadataPath).select("treeID", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"metadata", "weights"})).as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator5$2()))).rdd().map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int treeID = BoxesRunTime.unboxToInt((Object)tuple3._1());
                String json = (String)tuple3._2();
                double weights = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                if (true) {
                    int n = treeID;
                    if (json != null) {
                        String string = json;
                        if (true) {
                            double d = weights;
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)new Tuple2((Object)DefaultParamsReader$.MODULE$.parseMetadata(string, treeClassName), (Object)BoxesRunTime.boxToDouble((double)d)));
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple3);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(treesMetadataRDD, (Ordering)Ordering.Int$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class));
        boolean x$1 = qual$1.sortByKey$default$1();
        int x$2 = qual$1.sortByKey$default$2();
        Tuple2[] treesMetadataWeights = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(qual$1.sortByKey(x$1, x$2), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).values().collect();
        DefaultParamsReader.Metadata[] treesMetadata = (DefaultParamsReader.Metadata[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesMetadataWeights), (Function1 & Serializable)x$19 -> (DefaultParamsReader.Metadata)x$19._1(), ClassTag$.MODULE$.apply(DefaultParamsReader.Metadata.class));
        double[] treesWeights = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesMetadataWeights), (Function1 & Serializable)x$20 -> BoxesRunTime.boxToDouble((double)x$20._2$mcD$sp()), (ClassTag)ClassTag$.MODULE$.Double());
        String dataPath = new Path(path, "data").toString();
        Dataset df = sparkSession.read().parquet(dataPath);
        Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int major = tuple2._1$mcI$sp();
        int major2 = major;
        if (major2 < 3) {
            DataType dataType = df.schema().apply("nodeData").dataType();
            if (!(dataType instanceof StructType)) {
                throw new MatchError((Object)dataType);
            }
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            Column[] cols = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)f -> functions$.MODULE$.col("nodeData." + f.name()), ClassTag$.MODULE$.apply(Column.class))), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)-1L)).as("rawCount"), ClassTag$.MODULE$.apply(Column.class));
            Column newNodeDataCol = functions$.MODULE$.struct((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)cols).toImmutableArraySeq());
            df = df.withColumn("nodeData", newNodeDataCol);
        }
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.tree.EnsembleModelReadWrite.EnsembleNodeData").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator10$1() {
            }
        }
        RDD rootNodesRDD = RDD$.MODULE$.rddToPairRDDFunctions(df.as(sparkSession.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_tree_EnsembleModelReadWrite$$typecreator10$1()))).rdd().map((Function1 & Serializable)d -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)d.treeID()), (Object)d.nodeData()), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int treeID = tuple2._1$mcI$sp();
                Iterable nodeData = (Iterable)tuple2._2();
                if (true) {
                    int n = treeID;
                    if (nodeData != null) {
                        Iterable iterable = nodeData;
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)DecisionTreeModelReadWrite$.MODULE$.buildTreeFromNodes((DecisionTreeModelReadWrite.NodeData[])iterable.toArray(ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class)), impurityType));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        OrderedRDDFunctions qual$2 = RDD$.MODULE$.rddToOrderedRDDFunctions(rootNodesRDD, (Ordering)Ordering.Int$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Node.class));
        boolean x$3 = qual$2.sortByKey$default$1();
        int x$4 = qual$2.sortByKey$default$2();
        Node[] rootNodes = (Node[])RDD$.MODULE$.rddToPairRDDFunctions(qual$2.sortByKey(x$3, x$4), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Node.class), (Ordering)Ordering.Int$.MODULE$).values().collect();
        return new Tuple3((Object)metadata, (Object)ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])treesMetadata), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])rootNodes)), (Object)treesWeights);
    }

    private EnsembleModelReadWrite$() {
    }
}

